# Biuro websites

## Information 
- Project repository [dev.biuro](http://git.biuro.lt/biuro/dev.biuro)
- Created from [wordpress-nginx-docker](https://github.com/mjstealey/wordpress-nginx-docker)
- SSL Certificates are created with [SSL For Free](https://www.sslforfree.com/?domains=biuro.lt%20www.biuro.lt%20dev.biuro.lt%20staging.biuro.lt%20biuro.lv%20www.biuro.lv%20dev.biuro.lv%20staging.biuro.lv%20biuro.ee%20www.biuro.ee%20dev.biuro.ee%20staging.biuro.ee)

## Installation 
- Install [Docker Desktop](https://www.docker.com/products/docker-desktop) on your machine
	- Creating new User on my machine helped me with sharing C drive problem (https://tomssl.com/2018/01/11/sharing-your-c-drive-with-docker-for-windows-when-using-azure-active-directory-azuread-aad/) 
- Clone [dev.biuro](http://git.biuro.lt/biuro/dev.biuro) repository
- in Windows PowerShell run `docker-compose up -d` 
- `docker ps` command should output existing docker containers (nginx, mysql, wordpress)
- restore DB as written in *DB restore* section
- check if dev.biuro.lt, dev.biuro.lv, dev.biuro.ee (it should be set in hosts to 127.0.0.1)

## Workflow 

### Wordpress
- Regions created using [Wordpress Network](https://codex.wordpress.org/Create_A_Network)

#### DB backup
- `C:\web\dev.biuro>docker exec -i mysql mysqldump -u root -pIiIjnsLi2wR9i1kWVbVpUAzP wordpress > docker/mariadb/biuro_002.sql`

#### DB restore
- `C:\web\dev.biuro>cat docker/mariadb/biuro_001.sql | docker exec -i mysql /usr/bin/mysql -u root -pIiIjnsLi2wR9i1kWVbVpUAzP wordpress`

#### DB preview
- `docker exec -it mysql bash`
- `mysql -u root -pIiIjnsLi2wR9i1kWVbVpUAzP`
- `use wordpress;`

## Plugins

## Known issues (Windows 10)
### Error
### Solution


## Other
- docker-compose up -d
- docker-compose start
- docker-compose stop

- docker ps

- docker update --restart=no mysql
- docker update --restart=no nginx
- docker update --restart=no wordpress

- docker system prune --all

- docker restart mysql
- docker restart nginx
- docker restart wordpress

- https://docs.google.com/document/d/1FiwVoiLvGGmi9V-HPBgJ3gsh3wGswt27csgvfdTU24w/edit?usp=sharing
- https://docs.google.com/spreadsheets/d/1ggnqKuGxFFkLgI6NDZq4PXpRY_whdHX0kjZj7pCP_fk/edit?ts=5b5eaa62#gid=0
- https://docs.google.com/spreadsheets/d/1dXP0dh_v2sFajrcwR2_9HONMadCdZQW4Y2dVXvhxG3E/edit?ts=5b5eaa6b#gid=748245000